## Kako oddati?

Če boste rešili obvezno in dodatno nalogo, oddajte datoteko, v kateri je najprej dodatna naloga in šele nato obvezna. Boste videli, zakaj.

## Obvezna naloga
Imamo štiri vrstice besedila. Shranjene so v spodnji tabeli, kje se začnejo, pa pove zgornja tabela.

<img src="data:image/.png;base64,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"/>

Prva beseda se začne s tretjim elementom spodnje tabele, druga z dvanajstim, tretja z enajstim in četrta z osmim. Za primer, preberimo drugo vrstico.

<img src="data:image/.png;base64,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"/>

Začne se, kot smo rekli, na **12.** mestu.

- Na 12. mestu izvemo, da je prva črka **B**, naslednjo pa nam je iskati na **14.** mestu.
- Na 14. mestu piše, da je to črka **e**, naslednjo pa izvemo na **13.** mestu.
- Na 13. mestu piše, da je to črka **r**,  naslednjo pa nam je iskati na **7.** mestu.
- Na 7. mestu piše, da je to črka **t**, naslednjo pa nam je iskati na **6.** mestu.
- Na 6. mestu piše, da je to črka **a**, naslednjo pa nam je iskati na ... no, **-1** pomeni, da je to konec vrstice.

Na začetek programa napišite tabeli v takšni obliki:

```python
zacetki = [3, 12, 11, 8]
potek = [(-1, 'a'), (6, 'n'), (10, 'a'), (1, 'A'), (9, 'l'), (4, 'i'), (-1, 'a'), (6, 't'),
         (2, 'D'), (0, 'k'), (16, 'n'), (5, 'C'), (14, 'B'), (7, 'r'), (13, 'e'), (-1, 'a'), (-1, 'i')]
```

Program mora sestaviti seznam `besedilo`, ki vsebuje besedila vseh vrstic. Na konec programa dodajte `print(besedilo)`, da bo ta, ki popravlja, videl, da res deluje. Za gornji primer bi torej moral izpisati

```
['Ana', 'Berta', 'Cilka', 'Dani']
```

Ko to deluje, pa zamenjaj tabeli z naslednjima:

```python
zacetki = [119, 178, 321, 180, 17]
potek = [
    (100, 'h'), (37, 'e'), (134, 'm'), (280, 'r'), (146, 'v'), (83, 'i'), (149, ' '), (80, 'i'),
    (231, 'M'), (194, 'r'), (60, 's'), (40, 'o'), (237, 'k'), (6, 'i'), (92, 'a'), (170, 'e'),
    (58, 'i'), (11, 'k'), (44, 'm'), (171, 'r'), (126, 'u'), (151, 'd'), (248, 'i'), (98, 'v'),
    (168, 't'), (107, 'j'), (233, 'j'), (221, ' '), (65, 'a'), (257, 't'), (282, 'l'), (15, 'p'),
    (184, 'v'), (84, ' '), (263, ' '), (117, 's'), (175, ' '), (19, ' '), (270, 'l'), (220, 'l'),
    (46, 't'), (239, 'e'), (228, ' '), (71, 'v'), (268, 'a'), (104, 'i'), (271, ' '), (208, 'a'),
    (308, 'a'), (72, 'e'), (223, ' '), (256, 'č'), (181, 'p'), (55, ' '), (261, 'o'), (47, 'v'),
    (227, 'e'), (211, 'e'), (94, 'l'), (267, 'r'), (292, 't'), (190, 'r'), (251, 'g'), (197, 'i'), (219, ' '), (309, ' '), (204, 'j'), (230, 'o'), (296, 'n'), (198, ','), (5, 'n'), (77, 'e'),
    (105, 'p'), (173, 'G'), (153, 'a'), (166, 'a'), (177, 'l'), (125, 'm'), (289, 'o'), (272, 'š'),
    (298, ' '), (185, 'v'), (209, 's'), (293, 'c'), (150, 'z'), (20, 'j'), (141, 'd'), (235, 't'),
    (69, 'i'), (135, ' '), (301, 'č'), (130, ' '), (222, 'č'), (30, 'p'), (250, 'a'), (45, 'b'),
    (201, 'o'), (320, 'a'), (312, ' '), (96, 'r'), (258, 'l'), (137, ' '), (87, 'o'), (290, 's'),
    (28, 'l'), (214, 'r'), (13, 'm'), (191, 'i'), (286, 'm'), (64, 'o'), (0, ' '), (278, 'j'),
    (93, ' '), (43, 'd'), (262, 'p'), (139, ' '), (73, '.'), (303, 'a'), (240, 'h'), (102, 'K'),
    (158, ' '), (152, 'a'), (12, 'r'), (329, 'r'), (302, 'm'), (332, 'a'), (297, 'b'), (159, ' '),
    (8, ' '), (226, 'e'), (129, 'j'), (313, 'r'), (70, 'č'), (327, ' '), (205, 'o'), (276, 'o'),
    (38, 'e'), (316, 'b'), (75, 'p'), (167, 'r'), (306, 'j'), (283, 'r'), (265, 's'), (236, 'i'),
    (122, 'a'), (50, 'k'), (22, 's'), (91, 'e'), (118, ' '), (97, 'z'), (113, ' '), (63, 'r'),
    (323, 'v'), (144, 'd'), (109, 't'), (229, 't'), (311, 's'), (111, ' '), (32, 's'), (224, 'o'),
    (34, 'o'), (101, 'e'), (7, 'l'), (25, 'n'), (241, 'e'), (172, 'u'), (288, 'd'), (51, 'e'),
    (112, 'o'), (279, 't'), (42, 't'), (90, 'e'), (163, 'k'), (121, 'l'), (154, 's'), (199, 'p'),
    (244, 'i'), (295, 'o'), (285, 'N'), (246, 'i'), (202, 'k'), (49, 'r'), (200, 'm'), (215, ' '), (299, 'e'), (232, 'e'), (164, 'r'), (275, 'r'), (41, 'j'), (67, 'r'), (326, 'o'), (183, 'č'),
    (243, 'l'), (131, 'p'), (252, 'o'), (318, 'j'), (48, 'k'), (213, 'n'), (-1, ' '), (56, 'r'),
    (179, 'b'), (24, 's'), (59, 'e'), (147, 's'), (253, 'a'), (140, 'ž'), (305, 'r'), (242, 't'),
    (68, 'r'), (266, 'o'), (143, ' '), (9, 'p'), (145, 'a'), (212, 'j'), (315, 'o'), (161, 'j'),
    (106, 'i'), (99, 'p'), (176, 'k'), (31, 's'), (325, ' '), (186, 'p'), (33, 'e'), (85, 'l'),
    (138, 'd'), (281, 'a'), (269, ' '), (189, 'p'), (322, 'z'), (210, 'a'), (287, 's'), (21, 'o'),
    (76, 't'), (89, 'e'), (82, 'e'), (4, ' '), (249, 'n'), (162, 'o'), (182, 'u'), (95, ' '),
    (14, 'l'), (3, 'p'), (120, 'o'), (195, ' '), (2, ' '), (81, 's'), (114, ' '), (23, 'o'),
    (273, ' '), (203, ' '), (-1, ' '), (115, 'a'), (169, 's'), (307, 'l'), (193, ' '), (234, 'f'),
    (133, ','), (108, 'i'), (132, 'a'), (124, ' '), (319, 'e'), (196, 'n'), (57, 'r'), (238, 'g'), (324, 'a'), (192, 'i'), (128, 'r'), (317, ' '), (-1, '.'), (206, 'p'), (218, 'i'), (35, 'v'),
    (304, 'a'), (136, 'v'), (328, 'j'), (174, 'o'), (103, 'b'), (-1, '.'), (254, 'e'), (127, 'o'), (156, 'o'), (-1, '.'), (79, 'e'), (62, 'u'), (61, 'p'), (142, 'o'), (110, 'a'), (1, 't'),
    (331, 'l'), (26, ' '), (66, 'i'), (245, ' '), (216, 'n'), (18, 'a'), (36, 'l'), (225, 'b'),
    (10, 'o'), (294, 'i'), (78, 'j'), (16, 't'), (188, ' '), (277, 'i'), (300, 'u'), (264, 'k'),
    (155, 's'), (284, 'e'), (157, 'e'), (291, 'a'), (88, 'm'), (123, 'p'), (148, 'e'), (310, 't'),
    (165, 's'), (255, 'o'), (260, 'r'), (29, 's'), (39, 'i'), (160, 's'), (27, 'e'), (187, 'p'),
    (54, 'p'), (274, 'N'), (53, ' '), (259, 'a'), (86, ' '), (314, 'p'), (207, 's'), (74, 'k'),
    (330, 'e'), (217, 'e'), (247, 'g'), (116, 'i'), (52, ' ')]
```

Poženi, preveri, oddaj -- če rešuješ samo obvezno nalogo. Če tudi dodatno, pa beri naprej.

## Dodatna naloga

Napiši program, ki sem ga moral napisati, ko sem sestavljal podatke za to nalogo. :)

Program dobi seznam vrstic `["Ana", "Berta", "Cilka", "Dani"]` in sestavi seznama `zacetki` in `potek`. Potek mora biti naključno premešan - ob vsakem poganjanju programa drugačen, vrstice se lahko začenjajo in končujejo kjerkoli .... skratka, tako neumno kot zgoraj. Prav bodo prišle funkcije modula `random`, kot sta `randint` in `shuffle` ali pa celo `choice`.

Da dokažeš, da stvar dela, naj bo program oblikovan takole:

```python

besedilo = ["Ana", "Berta", "Cilka", "Dani"]`

# Sledi dodatna naloga, ki sestavi premešani tabeli

print(zacetki)
print(potek)

# Obvezni del, ki dekodira in izpiše tako sestavljene začetke in ta potek v `besedilo` (torej: povozi prvotni seznam)

print(besedilo)
```